/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.component;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.render.GammaModifier;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public class BrightnessComponent
implements ICaptureComponent {
    public float gammaPerStop = 0.01f;
    public float brightenPerStop = 0.4f;
    public float darkenPerStop = 0.3f;
    private final float brightnessStops;
    private final float additionalGamma;

    public BrightnessComponent(float brightnessStops) {
        this.brightnessStops = brightnessStops;
        this.additionalGamma = this.gammaPerStop * brightnessStops * ((1.0f - ((Double)Minecraft.m_91087_().f_91066_.m_231927_().m_231551_()).floatValue()) * 0.65f + 0.35f);
    }

    public float getBrightnessStops() {
        return this.brightnessStops;
    }

    @Override
    public void onDelayFrame(Capture capture, int delayFramesLeft) {
        if (delayFramesLeft <= 1 && GammaModifier.getAdditionalBrightness() == 0.0f) {
            GammaModifier.setAdditionalBrightness(this.additionalGamma);
            Minecraft.m_91087_().f_91063_.m_109154_().m_109880_();
        }
    }

    @Override
    public Color modifyPixel(Capture capture, int red, int green, int blue) {
        float bias;
        float stopsDif = this.brightnessStops;
        if (stopsDif == 0.0f) {
            return new Color(red, green, blue);
        }
        float brightness = 1.0f + stopsDif * (stopsDif < 0.0f ? this.darkenPerStop : this.brightenPerStop);
        float lightness = (float)(red + green + blue) / 765.0f;
        if (stopsDif < 0.0f) {
            bias = (1.0f - lightness) * 0.8f + 0.2f;
        } else {
            float curve = (float)Math.pow(Math.sin((double)lightness * Math.PI), 2.0);
            bias = lightness > 0.5f ? curve * 0.8f + 0.2f : curve * 0.5f + 0.5f;
        }
        float r = Mth.m_14179_((float)bias, (float)red, (float)((float)red * brightness));
        float g = Mth.m_14179_((float)bias, (float)green, (float)((float)green * brightness));
        float b = Mth.m_14179_((float)bias, (float)blue, (float)((float)blue * brightness));
        int[] rdst = this.redistribute(r, g, b);
        return new Color(Mth.m_14045_((int)((int)((r + (float)rdst[0]) / 2.0f)), (int)0, (int)255), Mth.m_14045_((int)((int)((g + (float)rdst[1]) / 2.0f)), (int)0, (int)255), Mth.m_14045_((int)((int)((b + (float)rdst[2]) / 2.0f)), (int)0, (int)255));
    }

    @Override
    public void screenshotTaken(Capture capture, NativeImage screenshot) {
        GammaModifier.setAdditionalBrightness(0.0f);
    }

    private int[] redistribute(float red, float green, float blue) {
        float threshold = 255.999f;
        float max = Math.max(red, Math.max(green, blue));
        if (max <= threshold) {
            return new int[]{Mth.m_14045_((int)Math.round(red), (int)0, (int)255), Mth.m_14045_((int)Math.round(green), (int)0, (int)255), Mth.m_14045_((int)Math.round(blue), (int)0, (int)255)};
        }
        float total = red + green + blue;
        if (total >= 3.0f * threshold) {
            return new int[]{(int)threshold, (int)threshold, (int)threshold};
        }
        float x = (3.0f * threshold - total) / (3.0f * max - total);
        float gray = threshold - x * max;
        return new int[]{Mth.m_14045_((int)Math.round(gray + x * red), (int)0, (int)255), Mth.m_14045_((int)Math.round(gray + x * green), (int)0, (int)255), Mth.m_14045_((int)Math.round(gray + x * blue), (int)0, (int)255)};
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BrightnessComponent that = (BrightnessComponent)obj;
        return Float.floatToIntBits(this.brightnessStops) == Float.floatToIntBits(that.brightnessStops);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.brightnessStops));
    }

    public String toString() {
        return "BrightnessModifier[brightnessStops=" + this.brightnessStops + "]";
    }
}

